<?php

class Config {
    // General Assembly Configuration
    const GENERAL_ASSEMBLY = 104;  // Current General Assembly number
    
    // Database Configuration (from .env)
    public static function getDatabaseConfig() {
        return [
            'host' => $_ENV['DB_HOST'],
            'user' => $_ENV['DB_USER'],
            'password' => $_ENV['DB_PASS'],
            'database' => $_ENV['DB_NAME']
        ];
    }
    
    // URL Configuration
    const BASE_URL = 'https://ilga.gov';
    const LEGISLATION_URL = 'https://ilga.gov/legislation';
    
    // Session Configuration
    const REGULAR_SESSION_ID = 1;
    const SPECIAL_SESSION_ID = 2;
} 