import mysql.connector
import os
from dotenv import load_dotenv

# Load environment variables
load_dotenv()

def get_db_connection():
    return mysql.connector.connect(
        host=os.getenv('DB_HOST'),
        user=os.getenv('DB_USER'),
        password=os.getenv('DB_PASS'),  # Changed from DB_PASSWORD to DB_PASS
        database=os.getenv('DB_NAME')
    )

def handle_db_error(e):
    from flask import jsonify
    return jsonify({
        "error": "Database error occurred",
        "message": str(e)
    }), 500